

<?php
// Configurações iniciais
header('Content-Type: text/html; charset=utf-8');
date_default_timezone_set('America/Sao_Paulo');

// Função para obter a versão do MySQL/MariaDB
function getDatabaseVersion() {
    try {
        // Tenta conectar ao banco de dados (substitua com suas credenciais)
        $dsn = 'mysql:host=localhost;charset=utf8';
        $user = 'userbd'; // Substitua pelo seu usuário
        $pass = 'passbd';     // Substitua pela sua senha
        
        $dbh = new PDO($dsn, $user, $pass);
        $version = $dbh->getAttribute(PDO::ATTR_SERVER_VERSION);
        
        // Determina se é MySQL ou MariaDB
        if (strpos(strtolower($version), 'mariadb') !== false) {
            return ['type' => 'MariaDB', 'version' => $version];
        } else {
            return ['type' => 'MySQL', 'version' => $version];
        }
    } catch (PDOException $e) {
        return ['type' => 'Erro', 'version' => 'Não foi possível conectar ao banco de dados'];
    }
}

// Obtém as versões
$dbInfo = getDatabaseVersion();
$phpVersion = phpversion();
$serverSoftware = $_SERVER['SERVER_SOFTWARE'] ?? 'N/A';
$currentDate = date('d/m/Y H:i:s');
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verificador de Versões MySQL e PHP</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3f37c9;
            --mysql-color: #00758f;
            --mariadb-color: #c0765a;
            --php-color: #777bb3;
        }
        
        body {
            background-color: #f8f9fa;
            font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
        }
        
        .version-card {
            border: none;
            border-radius: 12px;
            box-shadow: 0 6px 15px rgba(0,0,0,0.1);
            margin-bottom: 2rem;
        }
        
        .card-header-mysql {
            background: linear-gradient(135deg, var(--mysql-color), #005f73);
            color: white;
        }
        
        .card-header-mariadb {
            background: linear-gradient(135deg, var(--mariadb-color), #a05d44);
            color: white;
        }
        
        .card-header-php {
            background: linear-gradient(135deg, var(--php-color), #5d5d9e);
            color: white;
        }
        
        .version-badge {
            font-size: 1rem;
            font-family: 'Courier New', monospace;
            padding: 0.5rem 1rem;
        }
        
        .server-info {
            background-color: white;
            border-radius: 8px;
            padding: 1.25rem;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
    </style>
</head>
<body>
    <div class="container py-4">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <h1 class="text-center mb-4"><i class="bi bi-server"></i> Verificador de Versões MySQL e PHP</h1>
                
                <?php if ($dbInfo['type'] === 'MariaDB'): ?>
                <div class="card version-card">
                    <div class="card-header card-header-mariadb py-3">
                        <h4 class="mb-0"><i class="bi bi-database"></i> MariaDB</h4>
                    </div>
                    <div class="card-body">
                        <span class="badge bg-light text-dark version-badge">
                            <?php echo htmlspecialchars($dbInfo['version']); ?>
                        </span>
                        <p class="mt-2 mb-0">MariaDB é um fork do MySQL, desenvolvido pela comunidade.</p>
                    </div>
                </div>
                <?php elseif ($dbInfo['type'] === 'MySQL'): ?>
                <div class="card version-card">
                    <div class="card-header card-header-mysql py-3">
                        <h4 class="mb-0"><i class="bi bi-database"></i> MySQL</h4>
                    </div>
                    <div class="card-body">
                        <span class="badge bg-light text-dark version-badge">
                            <?php echo htmlspecialchars($dbInfo['version']); ?>
                        </span>
                        <p class="mt-2 mb-0">MySQL é um sistema de gerenciamento de banco de dados relacional.</p>
                    </div>
                </div>
                <?php else: ?>
                <div class="alert alert-danger">
                    <i class="bi bi-exclamation-triangle-fill"></i> <?php echo htmlspecialchars($dbInfo['version']); ?>
                    <p class="mt-2 mb-0">Verifique as credenciais de conexão no código fonte.</p>
                </div>
                <?php endif; ?>
                
                <div class="card version-card">
                    <div class="card-header card-header-php py-3">
                        <h4 class="mb-0"><i class="bi bi-filetype-php"></i> PHP</h4>
                    </div>
                    <div class="card-body">
                        <span class="badge bg-light text-dark version-badge">
                            <?php echo htmlspecialchars($phpVersion); ?>
                        </span>
                        <p class="mt-2 mb-0">PHP é uma linguagem de script especialmente adequada para desenvolvimento web.</p>
                    </div>
                </div>
                
                <div class="server-info mt-4">
                    <h5><i class="bi bi-pc-display"></i> Informações do Servidor</h5>
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <p><strong>Software:</strong> <?php echo htmlspecialchars($serverSoftware); ?></p>
                            <p><strong>Sistema:</strong> <?php echo PHP_OS; ?></p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Data/Hora:</strong> <?php echo $currentDate; ?></p>
                            <p><strong>Timezone:</strong> <?php echo date_default_timezone_get(); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <footer class="text-center text-muted mt-4 py-3">
        <small>Verificador de Versões &copy; <?php echo date('Y'); ?></small>
    </footer>

    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>